<?php
// delay.php - Loading screen ONLY
session_start();

if (!isset($_SESSION['delay_start'])) {
    $_SESSION['delay_start'] = time();
}

$elapsed_time = time() - $_SESSION['delay_start'];

if ($elapsed_time < 5) {
    $remaining_time = 5 - $elapsed_time;
?>
<!DOCTYPE html>
<html lang="fi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ladataan...</title>
    <!-- Favicon -->
    <link rel="icon" href="./assets/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="./assets/favicon.ico" type="image/x-icon">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-green-50 min-h-screen flex items-center justify-center">
    <div class="text-center p-8 max-w-sm">
        <div class="mb-6">
            <div class="w-20 h-20 border-4 border-green-200 border-t-green-500 rounded-full animate-spin mx-auto"></div>
        </div>
        <h1 class="text-2xl font-bold text-green-800 mb-2">Ladataan</h1>
        <p class="text-green-600 mb-6">Odota kunnes sisältösi valmistuu</p>
        <div class="text-green-700 font-medium">
            Lataus <span id="countdown"><?php echo $remaining_time; ?></span> sekunnin kuluttua
        </div>
    </div>

    <script>
        let seconds = <?php echo $remaining_time; ?>;
        const countdownElement = document.getElementById('countdown');
        
        const timer = setInterval(() => {
            seconds--;
            countdownElement.textContent = seconds;
            
            if (seconds <= 0) {
                clearInterval(timer);
                window.location.reload();
            }
        }, 1000);
    </script>
</body>
</html>
<?php
    exit(); // IMPORTANT: Stop here
}
// If 5 seconds have passed, we just continue to main file
// NO output here - just check and continue
?>